<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;

/**
 * GpwSession
 *
 * @ORM\Table(name="gpw_sessions")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\GpwSessionRepository")
 * @ORM\HasLifecycleCallbacks()
 *
 * @ExclusionPolicy("all")
 */
class GpwSession
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="index_id", type="integer")
     */
    private $indexId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date", type="datetime")
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $date;

    /**
     * @var float
     *
     * @ORM\Column(name="open", type="float")
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $open;

    /**
     * @var float
     *
     * @ORM\Column(name="high", type="float")
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $high;

    /**
     * @var float
     *
     * @ORM\Column(name="low", type="float")
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $low;

    /**
     * @var float
     *
     * @ORM\Column(name="close", type="float")
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $close;

    /**
     * @var float
     *
     * @ORM\Column(name="volume", type="float")
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $volume;

    /**
     * @var float
     *
     * @ORM\Column(name="oi", type="float")
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $oi;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="createAt", type="datetime")
     */
    private $createAt;

    /**
     * @ORM\ManyToOne(targetEntity="GpwIndex",inversedBy="sessions")
     * @ORM\JoinColumn(name="index_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $index;

    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createAt = new \DateTime();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set indexId
     *
     * @param integer $indexId
     * @return GpwSession
     */
    public function setIndexId($indexId)
    {
        $this->indexId = $indexId;
    
        return $this;
    }

    /**
     * Get indexId
     *
     * @return integer 
     */
    public function getIndexId()
    {
        return $this->indexId;
    }

    /**
     * Set date
     *
     * @param \DateTime $date
     * @return GpwSession
     */
    public function setDate($date)
    {
        $this->date = $date;
    
        return $this;
    }

    /**
     * Get date
     *
     * @return \DateTime 
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * Set open
     *
     * @param float $open
     * @return GpwSession
     */
    public function setOpen($open)
    {
        $this->open = $open;
    
        return $this;
    }

    /**
     * Get open
     *
     * @return float 
     */
    public function getOpen()
    {
        return $this->open;
    }

    /**
     * Set high
     *
     * @param float $high
     * @return GpwSession
     */
    public function setHigh($high)
    {
        $this->high = $high;
    
        return $this;
    }

    /**
     * Get high
     *
     * @return float 
     */
    public function getHigh()
    {
        return $this->high;
    }

    /**
     * Set low
     *
     * @param float $low
     * @return GpwSession
     */
    public function setLow($low)
    {
        $this->low = $low;
    
        return $this;
    }

    /**
     * Get low
     *
     * @return float 
     */
    public function getLow()
    {
        return $this->low;
    }

    /**
     * Set close
     *
     * @param float $close
     * @return GpwSession
     */
    public function setClose($close)
    {
        $this->close = $close;
    
        return $this;
    }

    /**
     * Get close
     *
     * @return float 
     */
    public function getClose()
    {
        return $this->close;
    }

    /**
     * Set volume
     *
     * @param float $volume
     * @return GpwSession
     */
    public function setVolume($volume)
    {
        $this->volume = $volume;
    
        return $this;
    }

    /**
     * Get volume
     *
     * @return float 
     */
    public function getVolume()
    {
        return $this->volume;
    }

    /**
     * Set createAt
     *
     * @param \DateTime $createAt
     * @return GpwSession
     */
    public function setCreateAt($createAt)
    {
        $this->createAt = $createAt;
    
        return $this;
    }

    /**
     * Get createAt
     *
     * @return \DateTime 
     */
    public function getCreateAt()
    {
        return $this->createAt;
    }

    /**
     * Set index
     *
     * @param \Import\ApiBundle\Entity\GpwIndex $index
     * @return GpwSession
     */
    public function setIndex(\Import\ApiBundle\Entity\GpwIndex $index = null)
    {
        $this->index = $index;
    
        return $this;
    }

    /**
     * Get index
     *
     * @return \Import\ApiBundle\Entity\GpwIndex 
     */
    public function getIndex()
    {
        return $this->index;
    }

    /**
     * Set oi
     *
     * @param float $oi
     * @return GpwSession
     */
    public function setOi($oi)
    {
        $this->oi = $oi;
    
        return $this;
    }

    /**
     * Get oi
     *
     * @return float 
     */
    public function getOi()
    {
        return $this->oi;
    }
}